<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $guarded = array('content');
    protected $fillable = array('title', 'image', 'category_id');

    public function user()
    {
        return $this->belongsTo('App\Http\Models\User');
    }

    public function category()
    {
        return $this->belongsTo('App\Http\Models\Category');
    }

}